% Primarily taken from LSM Toolbox, a plugin for ImageJ
%   Peter Li 12-Apr-07
%   Some rights reserved.  Licensed under Creative Commons: http://creativecommons.org/licenses/by-nc-sa/3.0/

CONTENTS_LSM_H = {
    'LSMINF'                ;...
    'LSMINF_2'              ;...
    'SCANINFO_HEXTAGMAP'    ;...
    'SAMPLINGMODE_MAP'      ;...
    'CHANNELCOLORS'         ;...
    'TIMESTAMPS'            ;...
    'CONTENTS_LSM_H'        ;...
};

TIFF_H;
CONTENTS_LSM_H = [CONTENTS_LSM_H;CONTENTS_TIFF_H];

LSMINF = struct(                                ...
    'unknown1'                  ,   '8*uchar'   ,...
    'DIMENSIONS'                ,   '3*uint32'  ,...
    'NUMBER_OF_CHANNELS'        ,   'uint32'    ,...
    'TIMESTACKSIZE'             ,   'uint32'    ,...
    'DATATYPE'                  ,   'uint32'    ,...
    'unknown2'                  ,   '8*uchar'   ,...
    'VOXELSIZES'                ,   '3*float64' ,...
    'unknown3'                  ,   '24*uchar'  ,...
    'SCANTYPE'                  ,   'uint16'    ,...
    'SPECTRALSCAN'              ,   'uint16'    ,...
    'DATATYPE2'                 ,   'uint32'    ,...
    'unknown4'                  ,   'uint32'    ,...
    'OFFSET_INPUTLUT'           ,   'uint32'    ,...
    'OFFSET_OUTPUTLUT'          ,   'uint32'    ,...
    'OFFSET_CHANNELSCOLORS'     ,   'uint32'    ,...
    'unknown5'                  ,   '8*uchar'   ,...
    'OFFSET_CHANNELDATATYPES'   ,   'uint32'    ,...
    'OFFSET_SCANINFO'           ,   'uint32'    ,...
    'unknown6'                  ,   'uint32'    ,...
    'OFFSET_TIMESTAMPS'         ,   'uint32'    ,...
    'unknown7'                  ,   '68*uchar'  ,...
    'OFFSET_CHANNELWAVELENGTH'  ,   'uint32'    ...
);

LSMINF_2 = struct(                                ...
    'MagicNumber'               ,   'uint32'    ,...
    'StructureSize'             ,   'uint32'    ,...
    'DimensionX'                ,   'uint32'    ,...
    'DimensionY'                ,   'uint32'    ,...
    'DimensionZ'                ,   'uint32'    ,...
    'DimensionChannels'         ,   'uint32'    ,...
    'DimensionTime'             ,   'uint32'    ,...
    'IntensityDataType'         ,   'uint32'    ,...
    'ThumbnailX'                ,   'uint32'    ,...
    'ThumbnailY'                ,   'uint32'    ,...
    'VoxelSizeX'                ,   'float64'   ,...
    'VoxelSizeY'                ,   'float64'   ,...
    'VoxelSizeZ'                ,   'float64'   ,...
    'OriginX'                   ,   'float64'   ,...
    'OriginY'                   ,   'float64'   ,...
    'OriginZ'                   ,   'float64'   ,...
    'ScanType'                  ,   'uint16'    ,...
    'SpectralScan'              ,   'uint16'    ,...
    'DataType'                  ,   'uint32'    ,...
    'OffsetVectorOverlay'       ,   'uint32'    ,...
    'OffsetInputLut'            ,   'uint32'    ,...
    'OffsetOutputLut'           ,   'uint32'    ,...
    'OffsetChannelColors'       ,   'uint32'    ,...
    'TimeInterval'              ,   'float64'   ,...
    'OffsetChannelDataTypes'    ,   'uint32'    ,...
    'OffsetScanInformation'     ,   'uint32'    ,...
    'OffsetKsData'              ,   'uint32'    ,...
    'OffsetTimeStamps'          ,   'uint32'    ,...
    'OffsetEventList'           ,   'uint32'    ,...
    'OffsetRoi'                 ,   'uint32'    ,...
    'OffsetBleachRoi'           ,   'uint32'    ,...
    'OffsetNextRecording'       ,   'uint32'    ,...
    'DisplayAspectX'            ,   'float64'   ,...
    'DisplayAspectY'            ,   'float64'   ,...
    'DisplayAspectZ'            ,   'float64'   ,...
    'DisplayAspectTime'         ,   'float64'   ,...
    'OffsetMeanOfRoisOverlay'   ,   'uint32'    ,...
    'OffsetTopoIsolineOverlay'  ,   'uint32'    ,...
    'OffsetTopoProfileOverlay'  ,   'uint32'    ,...
    'OffsetLinescanOverlay'     ,   'uint32'    ,...
    'ToolbarFlags'              ,   'uint32'    ,...
    'OffsetChannelWavelenth'    ,   'uint32'    ,...
    'OffsetChannelFactors'      ,   'uint32'    ,...
    'ObjectiveSphereCorrection' ,   'float64'   ,...
    'OffsetUnmixParameters'     ,   'uint32'    ...
);

SCANINFO_HEXTAGMAP = struct(    ...
	'h10000000'	,	'RECORDINGS'	,...
	'h10000001'	,	'ENTRY_NAME'	,...
	'h10000002'	,	'ENTRY_DESCRIPTION'	,...
	'h10000003'	,	'ENTRY_NOTES'	,...
	'h10000004'	,	'ENTRY_OBJECTIVE'	,...
	'h10000005'	,	'PROCESSING_SUMMARY'	,...
	'h10000006'	,	'SPECIAL_SCAN'	,...
	'h10000007'	,	'SCAN_TYPE'	,...
	'h10000008'	,	'SCAN_MODE'	,...
	'h10000009'	,	'STACKS_COUNT'	,...
	'h1000000A'	,	'LINES_PER_PLANE'	,...
	'h1000000B'	,	'SAMPLES_PER_LINE'	,...
	'h1000000C'	,	'PLANES_PER_VOLUME'	,...
	'h1000000D'	,	'IMAGES_WIDTH'	,...
	'h1000000E'	,	'IMAGES_HEIGHT'	,...
	'h1000000F'	,	'NUMBER_OF_PLANES'	,...
	'h10000010'	,	'IMAGES_NUMBER_STACKS'	,...
	'h10000011'	,	'IMAGES_NUMBER_CHANNELS'	,...
	'h10000012'	,	'LINESCAN_XY'	,...
	'h10000013'	,	'SCAN_DIRECTION'	,...
	'h10000014'	,	'TIME_SERIES'	,...
	'h10000015'	,	'ORIGNAL_SCAN_DATA'	,...
	'h10000016'	,	'ZOOM_X'	,...
	'h10000017'	,	'ZOOM_Y'	,...
	'h10000018'	,	'ZOOM_Z'	,...
	'h10000019'	,	'SAMPLE_0X'	,...
	'h1000001A'	,	'SAMPLE_0Y'	,...
	'h1000001B'	,	'SAMPLE_0Z'	,...
	'h1000001C'	,	'SAMPLE_SPACING'	,...
	'h1000001D'	,	'LINE_SPACING'	,...
	'h1000001E'	,	'PLANE_SPACING'	,...
	'h1000001F'	,	'PLANE_WIDTH'	,...
	'h10000020'	,	'PLANE_HEIGHT'	,...
	'h10000021'	,	'VOLUME_DEPTH'	,...
	'h10000034'	,	'ROTATION'	,...
	'h10000035'	,	'PRECESSION'	,...
	'h10000036'	,	'SAMPLE_0TIME'	,...
	'h10000037'	,	'START_SCAN_TRIGGER_IN'	,...
	'h10000038'	,	'START_SCAN_TRIGGER_OUT'	,...
	'h10000039'	,	'START_SCAN_EVENT'	,...
	'h10000040'	,	'START_SCAN_TIME'	,...
	'h10000041'	,	'STOP_SCAN_TRIGGER_IN'	,...
	'h10000042'	,	'STOP_SCAN_TRIGGER_OUT'	,...
	'h10000043'	,	'STOP_SCAN_EVENT'	,...
	'h10000044'	,	'START_SCAN_TIME2'	,...
	'h10000045'	,	'USE_ROIS'	,...
	'h10000046'	,	'USE_REDUCED_MEMORY_ROIS'	,...
	'h10000047'	,	'USER'	,...
	'h10000048'	,	'USE_BCCORECCTION'	,...
	'h10000049'	,	'POSITION_BCCORRECTION1'	,...
	'h10000050'	,	'POSITION_BCCORRECTION2'	,...
	'h10000051'	,	'INTERPOLATIONY'	,...
    'h10000052' ,   'CAMERA_BINNING'    ,...
    'h10000053' ,   'CAMERA_SUPERSAMPLING'    ,...
    'h10000054' ,   'CAMERA_FRAME_WIDTH'    ,...
    'h10000055' ,   'CAMERA_FRAME_HEIGHT'    ,...
    'h10000056' ,   'CAMERA_OFFSETX'    ,...
    'h10000057' ,   'CAMERA_OFFSETY'    ,...
    'h11000000'	,	'TIMERS'	,...
	'h12000000'	,	'TIMER'	,...
	'h12000001'	,	'TIMER_NAME'	,...
	'h12000003'	,	'INTERVAL'	,...
	'h12000004'	,	'TRIGGER_IN'	,...
	'h12000005'	,	'TRIGGER_OUT'	,...
    'h13000000'	,	'MARKERS'	,...
	'h14000000'	,	'MARKER'	,...
	'h14000001'	,	'MARKER_NAME'	,...
	'h14000002'	,	'DESCRIPTION'	,...
	'h14000003'	,	'TRIGGER_IN'	,...
	'h14000004'	,	'TRIGGER_OUT'	,...
    'h20000000'	,	'TRACKS'	,...
	'h30000000'	,	'LASERS'	,...
	'h40000000'	,	'TRACK'	,...
	'h40000001'	,	'MULTIPLEX_TYPE'	,...
	'h40000002'	,	'MULTIPLEX_ORDER'	,...
	'h40000003'	,	'SAMPLING_MODE'	,...
	'h40000004'	,	'SAMPLING_METHOD'	,...
	'h40000005'	,	'SAMPLING_NUMBER'	,...
	'h40000006'	,	'ENTRY_ACQUIRE'	,...
	'h40000007'	,	'OBSERVATION_TIME'	,...
	'h4000000B'	,	'TIME_BETWEEN_STACKS'	,...
	'h4000000C'	,	'TRACK_NAME'	,...
	'h4000000D'	,	'COLLIMATOR1_NAME'	,...
	'h4000000E'	,	'COLLIMATOR1_POSITION'	,...
	'h4000000F'	,	'COLLIMATOR2_NAME'	,...
	'h40000010'	,	'COLLIMATOR2_POSITION'	,...
	'h40000011'	,	'BLEACH_TRACK'	,...
	'h40000012'	,	'BLEACH_AFTER_SCAN_NUMBER'	,...
	'h40000013'	,	'BLEACH_SCAN_NUMBER'	,...
	'h40000014'	,	'TRIGGER_IN'	,...
	'h40000015'	,	'TRIGGER_OUT'	,...
	'h40000016'	,	'IS_RATIO_TRACK'	,...
	'h40000017'	,	'BLEACH_COUNT'	,...
	'h40000018'	,	'SPI_CENTER_WAVELENGTH'	,...
	'h40000019'	,	'PIXEL_TIME'	,...
	'h40000020' , 	'ID_CONDENSOR_FRONTLENS'	,...
  	'h40000021' , 	'CONDENSOR_FRONTLENS'	,...
	'h40000022' , 	'ID_FIELD_STOP'	,...
	'h40000023' , 	'FIELD_STOP_VALUE'	,...
	'h40000024' , 	'ID_CONDENSOR_APERTURE'	,...
	'h40000025' , 	'CONDENSOR_APERTURE'	,...
	'h40000026' , 	'ID_CONDENSOR_REVOLVER'	,...
	'h40000027' , 	'CONDENSOR_FILTER'	,...
	'h40000028' , 	'ID_TRANSMISSION_FILTER1'	,...
	'h40000029' , 	'ID_TRANSMISSION1'	,...
	'h40000030' , 	'ID_TRANSMISSION_FILTER2'	,...
	'h40000031' , 	'ID_TRANSMISSION2'	,...
	'h40000032' , 	'REPEAT_BLEACH'	,...
	'h40000033' , 	'ENABLE_SPOT_BLEACH_POS'	,...
	'h40000034' , 	'SPOT_BLEACH_POSX'	,...
	'h40000035' , 	'SPOT_BLEACH_POSY'	,...
	'h40000036' , 	'BLEACH_POSITION_Z'	,...
	'h40000037' , 	'ID_TUBELENS'	,...
	'h40000038' , 	'ID_TUBELENS_POSITION'	,...
	'h40000039' , 	'TRANSMITTED_LIGHT'	,...
	'h4000003a' , 	'REFLECTED_LIGHT'	,...
	'h4000003b' , 	'TRACK_SIMULTAN_GRAB_AND_BLEACH'	,...
	'h4000003c' , 	'BLEACH_PIXEL_TIME'	,...
	'h50000000'	,	'LASER'	,...
	'h50000001'	,	'LASER_NAME'	,...
	'h50000002'	,	'LASER_ACQUIRE'	,...
	'h50000003'	,	'LASER_POWER'	,...
	'h60000000'	,	'DETECTION_CHANNELS'	,...
	'h70000000'	,	'DETECTION_CHANNEL'	,...
	'h70000003'	,	'DETECTOR_GAIN'	,...
	'h70000005'	,	'AMPLIFIER_GAIN'	,...
	'h70000007'	,	'AMPLIFIER_OFFSET'	,...
	'h70000009'	,	'PINHOLE_DIAMETER'	,...
	'h7000000B'	,	'ENTRY_ACQUIRE'	,...
	'h7000000C'	,	'DETECTOR_NAME'	,...
	'h7000000D'	,	'AMPLIFIER_NAME'	,...
	'h7000000E'	,	'PINHOLE_NAME'	,...
	'h7000000F'	,	'FILTER_SET_NAME'	,...
	'h70000010'	,	'FILTER_NAME'	,...
	'h70000013'	,	'INTEGRATOR_NAME'	,...
	'h70000014'	,	'DETECTION_CHANNEL_NAME'	,...
	'h70000015'	,	'DETECTOR_GAIN_BC1'	,...
	'h70000016'	,	'DETECTOR_GAIN_BC2'	,...
	'h70000017'	,	'AMPLIFIER_GAIN_BC1'	,...
	'h70000018'	,	'AMPLIFIER_GAIN_BC2'	,...
	'h70000019'	,	'AMPLIFIER_OFFSET_BC1'	,...
	'h70000020'	,	'AMPLIFIER_OFFSET_BC2'	,...
	'h70000021'	,	'SPECTRAL_SCAN_CHANNELS'	,...
	'h70000022'	,	'SPI_WAVE_LENGTH_START'	,...
	'h70000023'	,	'SPI_WAVELENGTH_END'	,...
	'h70000026'	,	'DYE_NAME'	,...
	'h70000027'	,	'DYE_FOLDER'	,...
	'h80000000'	,	'ILLUMINATION_CHANNELS'	,...
	'h90000000'	,	'ILLUMINATION_CHANNEL'	,...
	'h90000001'	,	'ILL_NAME'	,...
	'h90000002'	,	'POWER'	,...
	'h90000003'	,	'WAVELENGTH'	,...
	'h90000004'	,	'ACQUIRE'	,...
	'h90000005'	,	'DETCHANNEL_NAME'	,...
	'h90000006'	,	'POWER_BC1'	,...
    'h90000007'	,	'POWER_BC2'	,...
	'hA0000000'	,	'BEAM_SPLITTERS'	,...
	'hB0000000'	,	'BEAM_SPLITTER'	,...
	'hB0000001'	,	'FILTER_SET'	,...
	'hB0000002'	,	'FILTER'	,...
	'hB0000003'	,	'BS_NAME'	,...
	'hC0000000'	,	'DATA_CHANNELS'	,...
	'hD0000000'	,	'DATA_CHANNEL'	,...
	'hD0000001'	,	'DATA_NAME'	,...
	'hD0000004'	,	'COLOR'	,...
	'hD0000005'	,	'SAMPLETYPE'	,...
	'hD0000006'	,	'BITS_PER_SAMPLE'	,...
	'hD0000007'	,	'RATIO_TYPE'	,...
	'hD0000008'	,	'RATIO_TRACK1'	,...
	'hD0000009'	,	'RATIO_TRACK2'	,...
	'hD000000A'	,	'RATIO_CHANNEL1'	,...
	'hD000000B'	,	'RATIO_CHANNEL2'	,...
	'hD000000C'	,	'RATIO_CONST1'	,...
	'hD000000D'	,	'RATIO_CONST2'	,...
	'hD000000E'	,	'RATIO_CONST3'	,...
	'hD000000F'	,	'RATIO_CONST4'	,...
	'hD0000010' ,	'RATIO_CONST5'	,...
	'hD0000011' ,	'RATIO_CONST6'	,...
	'hD0000012' ,	'RATIO_FIRST_IMAGES1'	,...
	'hD0000013' ,	'RATIO_FIRST_IMAGES2'	,...
	'hD0000014' ,	'DYE_NAME'	,...
	'hD0000015' ,	'DYE_FOLDER'	,...
	'hD0000016' ,	'SPECTRUM'	,...
	'hD0000017' ,	'ACQUIRE'	,...
	'hFFFFFFFF'	,	'END_SUBBLOCK'  ...
);

SAMPLINGMODE_MAP = struct(  ...
    'x0'    ,   'Sample - No Average'   ,...
    'x1'    ,   'Line Average'          ,...
    'x2'    ,   'Frame Average'         ,...
    'x3'    ,   'Integration Mode'      ...
);

CHANNELCOLORS = struct( ...
    'BlockSize'     ,   'int32'    ,...
    'NumberColors'  ,   'int32'    ,...
    'NumberNames'   ,   'int32'    ,...
    'ColorsOffset'  ,   'int32'    ,...
    'NamesOffset'   ,   'int32'    ,...
    'Mono'          ,   'int32'    ...
);

TIMESTAMPS = struct( ...
    'Size'              ,   'int32'     ,...
    'NumberTimeStamps'  ,   'int32'     ...
);
